/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.huesync.internal.handler;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.openhab.binding.huesync.internal.HueSyncBindingConstants;
import org.openhab.binding.huesync.internal.HueSyncState;
import org.openhab.binding.huesync.internal.HueSyncStateChangedListener;
import org.openhab.binding.huesync.internal.UnsupportedCommandTypeException;
import org.openhab.binding.huesync.internal.config.HueSyncConfiguration;
import org.openhab.binding.huesync.internal.connector.HueSyncApiConnector;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingStatus;
import org.openhab.core.thing.ThingStatusDetail;
import org.openhab.core.thing.binding.BaseThingHandler;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueSyncHandler
extends BaseThingHandler
implements HueSyncStateChangedListener {
    private static final int RECONNECT_TIME_SECONDS = 30;
    private HttpClient httpClient;
    private HueSyncApiConnector connector;
    private HueSyncConfiguration config;
    private HueSyncState hueSyncState;
    private ScheduledFuture<?> retryJob;
    private final Logger logger = LoggerFactory.getLogger(HueSyncHandler.class);

    public HueSyncHandler(Thing thing, HttpClient httpClient) {
        super(thing);
        this.httpClient = httpClient;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (this.connector == null) {
            return;
        }
        if (command instanceof RefreshType) {
            return;
        }
        try {
            switch (channelUID.getId()) {
                case "power": {
                    this.connector.sendExecCommand("{\"hdmiActive\":" + Boolean.toString(command == OnOffType.ON) + "}");
                    break;
                }
                case "mode": {
                    this.connector.sendExecCommand("{\"mode\":\"" + command + "\"}");
                    break;
                }
                case "brightness": {
                    if (command instanceof OnOffType) {
                        this.connector.sendExecCommand("{\"syncActive\":" + Boolean.toString(command == OnOffType.ON) + "}");
                    } else {
                        if (this.hueSyncState.getStateForChannelID("syncStatus") == OnOffType.OFF) {
                            this.connector.sendExecCommand("{\"syncActive\":true}");
                        }
                        int brightness = (int)Double.parseDouble(command.toString()) * 2;
                        this.connector.sendExecCommand("{\"brightness\":" + brightness + "}");
                    }
                    break;
                }
                case "intensity": {
                    this.connector.sendExecCommand("{\"intensity\":\"" + command + "\"}");
                    break;
                }
                case "input": {
                    this.connector.sendExecCommand("{\"hdmiSource\":\"" + command + "\"}");
                    break;
                }
                case "syncStatus": {
                    this.connector.sendExecCommand("{\"syncActive\":" + Boolean.toString(command == OnOffType.ON) + "}");
                    break;
                }
                default: {
                    throw new UnsupportedCommandTypeException();
                }
            }
        }
        catch (UnsupportedCommandTypeException e) {
            this.logger.warn("Unsupported command {} for channel {}", (Object)command, (Object)channelUID.getId());
        }
    }

    public boolean checkConfiguration() {
        if (this.config.httpPollingInterval < 5) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "The polling interval should be at least 5 seconds!");
            return false;
        }
        return true;
    }

    public void initialize() {
        this.logger.debug("Initializing HueSync-Box Thing handler - Thing Type: {}; Thing ID: {}.", (Object)HueSyncBindingConstants.THING_TYPE_SYNCBOX, (Object)this.getThing().getUID());
        this.cancelRetryJob();
        this.config = (HueSyncConfiguration)this.getConfigAs(HueSyncConfiguration.class);
        if (!this.checkConfiguration()) {
            return;
        }
        this.hueSyncState = new HueSyncState(this);
        this.updateStatus(ThingStatus.UNKNOWN);
        if (this.config.getApiAccessToken().isBlank()) {
            String warnMessage = "Cannot connect to huesync-box. API Access Token is not available in configuration.";
            this.logger.warn(warnMessage);
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, warnMessage);
        }
        this.createConnection();
    }

    private void createConnection() {
        this.logger.trace("createConnection()");
        if (this.connector != null) {
            this.connector.dispose();
        }
        this.connector = new HueSyncApiConnector(this.config, this.hueSyncState, this.scheduler, this.httpClient);
        this.connector.createConnection();
    }

    private void cancelRetryJob() {
        if (this.retryJob != null && !this.retryJob.isDone()) {
            this.retryJob.cancel(false);
        }
    }

    public void dispose() {
        if (this.connector != null) {
            this.connector.dispose();
            this.connector = null;
        }
        this.cancelRetryJob();
        super.dispose();
    }

    public void channelLinked(ChannelUID channelUID) {
        State state;
        super.channelLinked(channelUID);
        String channelID = channelUID.getId();
        if (this.isLinked(channelID) && (state = this.hueSyncState.getStateForChannelID(channelID)) != null) {
            this.updateState(channelID, state);
        }
    }

    @Override
    public void stateChanged(String channelID, State state) {
        this.logger.debug("Received state {} for channelID {}", (Object)state, (Object)channelID);
        if (this.getThing().getStatus() != ThingStatus.ONLINE) {
            this.updateStatus(ThingStatus.ONLINE);
        }
        this.updateState(channelID, state);
        if (!(this.config.getApiAccessToken().isBlank() || this.getThing().getConfiguration().get("apiAccessToken") != null && this.getThing().getConfiguration().get("apiAccessToken").equals(this.config.getApiAccessToken()))) {
            this.logger.debug("API Token changed! Updating Thing Configuration ...");
            Configuration editConfig = this.editConfiguration();
            editConfig.put("apiAccessToken", (Object)this.config.getApiAccessToken());
            this.updateConfiguration(editConfig);
        }
    }

    @Override
    public void connectionError(String errorMessage) {
        this.logger.debug("huesync-box connection error: {}", (Object)errorMessage);
        if (this.getThing().getStatus() != ThingStatus.OFFLINE) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, errorMessage);
        }
        this.connector.dispose();
        this.logger.debug("Trying again in {}s", (Object)30);
        this.retryJob = this.scheduler.schedule(this::createConnection, 30L, TimeUnit.SECONDS);
    }
}

