/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.huesync.internal.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jmdns.ServiceInfo;
import org.openhab.binding.huesync.internal.HueSyncBindingConstants;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultBuilder;
import org.openhab.core.config.discovery.mdns.MDNSDiscoveryParticipant;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class HueSyncDiscoveryParticipant
implements MDNSDiscoveryParticipant {
    private Logger logger = LoggerFactory.getLogger(HueSyncDiscoveryParticipant.class);
    private static final String RAOP_SERVICE_TYPE = "_huesync._tcp.local.";
    private static final Pattern PHILIPS_SYNCBOX_PATTERN = Pattern.compile("^(.*)-(.*)\\._huesync\\._tcp\\.local\\.$");

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return Collections.singleton(HueSyncBindingConstants.THING_TYPE_SYNCBOX);
    }

    public String getServiceType() {
        return RAOP_SERVICE_TYPE;
    }

    public DiscoveryResult createResult(ServiceInfo serviceInfo) {
        String qualifiedName = serviceInfo.getQualifiedName();
        this.logger.debug("HueSync Device found: {}", (Object)qualifiedName);
        ThingUID thingUID = this.getThingUID(serviceInfo);
        if (thingUID != null) {
            Matcher matcher = PHILIPS_SYNCBOX_PATTERN.matcher(qualifiedName);
            matcher.matches();
            String vendor = "Philips";
            String model = "Hue Play HDMI Sync Box";
            String friendlyName = "Philips Hue HDMI Sync Box";
            String hostname = (String.valueOf(matcher.group(1)) + "-" + matcher.group(2)).toLowerCase();
            String serial = matcher.group(2);
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put("host", hostname);
            properties.put("serialNumber", serial);
            properties.put("vendor", vendor);
            properties.put("modelId", model);
            this.logger.debug("thing properties: {}", properties);
            DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)thingUID).withProperties(properties).withRepresentationProperty("serialNumber").withLabel(friendlyName).build();
            return result;
        }
        this.logger.debug("This discovered device is not supported by the HueSync binding, ignoring...");
        return null;
    }

    public ThingUID getThingUID(ServiceInfo service) {
        Matcher matcher = PHILIPS_SYNCBOX_PATTERN.matcher(service.getQualifiedName());
        if (matcher.matches()) {
            String serial = matcher.group(2).toLowerCase();
            return new ThingUID(HueSyncBindingConstants.THING_TYPE_SYNCBOX, serial);
        }
        return null;
    }
}

