/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.huesync.internal.connector;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.openhab.binding.huesync.internal.HueSyncState;
import org.openhab.binding.huesync.internal.config.HueSyncConfiguration;
import org.openhab.core.id.InstanceUUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueSyncApiConnector {
    private final String apiUrl;
    private final HttpClient httpClient;
    private static final String URL_DEVICE_INFO = "/device";
    private static final String URL_EXEC_COMMAND = "/execution";
    private static final String URL_REGISTRATION = "/registrations";
    private static final int REQUEST_TIMEOUT_MS = 5000;
    private ScheduledFuture<?> pollingJob;
    private Logger logger = LoggerFactory.getLogger(HueSyncApiConnector.class);
    private ScheduledExecutorService scheduler;
    private HueSyncState state;
    private HueSyncConfiguration config;

    public HueSyncApiConnector(HueSyncConfiguration config, HueSyncState state, ScheduledExecutorService scheduler, HttpClient httpClient) {
        this.config = config;
        this.scheduler = scheduler;
        this.state = state;
        this.apiUrl = String.format("https://%s/api/v1", config.getHost());
        this.httpClient = httpClient;
    }

    public HueSyncState getState() {
        return this.state;
    }

    public void createConnection() {
        if (this.setConfigProperties()) {
            if (this.config.getApiAccessToken() == null || this.config.getApiAccessToken().isBlank()) {
                this.startPairingProcess();
            } else {
                this.startStatusPolling();
            }
        }
    }

    private void startStatusPolling() {
        this.stopPolling();
        this.pollingJob = this.scheduler.scheduleWithFixedDelay(() -> this.updateBoxState(), 0L, this.config.httpPollingInterval.intValue(), TimeUnit.SECONDS);
        this.logger.debug("HTTP polling started.");
    }

    private boolean isPolling() {
        return this.pollingJob != null && !this.pollingJob.isCancelled();
    }

    private void stopPolling() {
        if (this.isPolling()) {
            this.pollingJob.cancel(true);
            this.logger.debug("HTTP polling stopped.");
        }
    }

    public void dispose() {
        this.logger.trace("disposing connector");
        this.stopPolling();
    }

    protected void startPairingProcess() {
        this.logger.info("Creating new user on huesync-box");
        this.stopPolling();
        String url = String.valueOf(this.apiUrl) + URL_REGISTRATION;
        String command = "{\"appName\":\"openhab\",\"instanceName\":\"huesync-" + InstanceUUID.get() + "\"}";
        this.pollingJob = this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.logger.debug("Sending registration command '{}' to '{}'", (Object)command, (Object)url);
                String jsonString = this.httpClient.newRequest(url).method(HttpMethod.POST).header(HttpHeader.CONTENT_TYPE, "application/json").timeout(2L, TimeUnit.SECONDS).content((ContentProvider)new StringContentProvider(command)).send().getContentAsString();
                JsonObject jsonObject = new JsonParser().parse(jsonString).getAsJsonObject();
                this.logger.trace("Received response: {}", (Object)jsonObject);
                if (jsonObject.get("accessToken") != null) {
                    String accessToken = jsonObject.get("accessToken").getAsString();
                    this.logger.info("Pairing with huesync-box successfully finished");
                    this.config.setApiAccessToken(accessToken);
                    this.startStatusPolling();
                    return;
                }
                if (jsonObject.get("code") != null) {
                    int statusCode = jsonObject.get("code").getAsInt();
                    if (statusCode == 16) {
                        this.logger.info("Please press the pairing button on your HueSync Box for 3 seconds until the LED blinks green!");
                    } else {
                        this.logger.debug("Unhandled statusCode: {}", (Object)statusCode);
                    }
                } else {
                    this.logger.debug("Unhandled response type: {}", (Object)jsonObject);
                }
            }
            catch (Exception e) {
                this.logger.error("Error sending registration command: {}", (Object)e.getMessage());
            }
        }, 0L, 3L, TimeUnit.SECONDS);
    }

    public void sendExecCommand(String command) {
        if (command == null || command.isBlank()) {
            this.logger.warn("Can not send empty command to huesync-box!");
            return;
        }
        String url = String.valueOf(this.apiUrl) + URL_EXEC_COMMAND;
        this.logger.debug("Sending command '{}' to '{}'", (Object)command, (Object)URL_EXEC_COMMAND);
        this.httpClient.newRequest(url).method(HttpMethod.PUT).header(HttpHeader.CONTENT_TYPE, "application/json").timeout(5000L, TimeUnit.MILLISECONDS).header("Authorization", "Bearer " + this.config.getApiAccessToken()).content((ContentProvider)new StringContentProvider(command)).send(new Response.CompleteListener(){

            public void onComplete(Result result) {
                HueSyncApiConnector.this.logger.debug("Status code {}", (Object)result.getResponse().getStatus());
                if (result.getResponse().getStatus() != 200) {
                    HueSyncApiConnector.this.logger.warn("Error {} while sending command", (Object)result.getResponse().getReason());
                }
            }
        });
        this.updateBoxState();
    }

    private boolean setConfigProperties() {
        this.logger.trace("setConfigProperties(): Not implemented yet ...");
        String url = String.valueOf(this.apiUrl) + URL_DEVICE_INFO;
        JsonObject deviceData = this.getJsonResponse(url, false);
        return deviceData != null;
    }

    private void updateBoxState() {
        this.logger.debug("Updating state of huesync-box ...");
        String url = this.apiUrl;
        JsonObject deviceData = this.getJsonResponse(url, true);
        if (deviceData != null) {
            try {
                String mode = deviceData.getAsJsonObject("execution").get("mode").getAsString();
                this.state.setMode(mode);
                if (deviceData.getAsJsonObject("execution").get(mode) != null) {
                    this.state.setIntensity(deviceData.getAsJsonObject("execution").getAsJsonObject(mode).get("intensity").getAsString());
                }
                this.state.setPower(deviceData.getAsJsonObject("execution").get("hdmiActive").getAsBoolean());
                this.state.setInput(deviceData.getAsJsonObject("execution").get("hdmiSource").getAsString());
                this.state.setSyncStatus(deviceData.getAsJsonObject("execution").get("syncActive").getAsBoolean());
                this.state.setBrightness(deviceData.getAsJsonObject("execution").get("brightness").getAsInt() / 2);
                JsonObject input1 = deviceData.getAsJsonObject("hdmi").getAsJsonObject("input1");
                this.state.setInput1Name(input1.get("name").getAsString());
                this.state.setInput1Type(input1.get("type").getAsString());
                this.state.setInput1Status(input1.get("status").getAsString());
                this.state.setInput1LastMode(input1.get("lastSyncMode").getAsString());
                JsonObject input2 = deviceData.getAsJsonObject("hdmi").getAsJsonObject("input2");
                this.state.setInput2Name(input2.get("name").getAsString());
                this.state.setInput2Type(input2.get("type").getAsString());
                this.state.setInput2Status(input2.get("status").getAsString());
                this.state.setInput2LastMode(input2.get("lastSyncMode").getAsString());
                JsonObject input3 = deviceData.getAsJsonObject("hdmi").getAsJsonObject("input3");
                this.state.setInput3Name(input3.get("name").getAsString());
                this.state.setInput3Type(input3.get("type").getAsString());
                this.state.setInput3Status(input3.get("status").getAsString());
                this.state.setInput3LastMode(input3.get("lastSyncMode").getAsString());
                JsonObject input4 = deviceData.getAsJsonObject("hdmi").getAsJsonObject("input4");
                this.state.setInput4Name(input4.get("name").getAsString());
                this.state.setInput4Type(input4.get("type").getAsString());
                this.state.setInput4Status(input4.get("status").getAsString());
                this.state.setInput4LastMode(input4.get("lastSyncMode").getAsString());
                JsonObject output = deviceData.getAsJsonObject("hdmi").getAsJsonObject("output");
                this.state.setOutputName(output.get("name").getAsString());
                this.state.setOutputType(output.get("type").getAsString());
                this.state.setOutputStatus(output.get("status").getAsString());
                this.state.setOutputLastMode(output.get("lastSyncMode").getAsString());
            }
            catch (Exception e) {
                this.stopPolling();
                this.state.connectionError("Internal Error while updating box state: " + e.getMessage());
            }
        }
    }

    private @Nullable JsonObject getJsonResponse(String uri, Boolean auth) {
        this.logger.trace("getJsonResponse() from '{}' with auth '{}'", (Object)uri, (Object)auth);
        try {
            Request request = this.httpClient.newRequest(uri);
            request.timeout(5000L, TimeUnit.MILLISECONDS);
            if (auth.booleanValue()) {
                request.header("Authorization", "Bearer " + this.config.getApiAccessToken());
            }
            String jsonString = request.send().getContentAsString();
            JsonObject jsonObject = new JsonParser().parse(jsonString).getAsJsonObject();
            this.logger.trace("jsonString: {}", (Object)jsonString);
            return jsonObject;
        }
        catch (Exception e) {
            this.stopPolling();
            this.state.connectionError("API Error: " + e.getMessage());
            return null;
        }
    }
}

