/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.huesync.internal;

import org.openhab.binding.huesync.internal.HueSyncStateChangedListener;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.library.types.StringType;
import org.openhab.core.types.State;

public class HueSyncState {
    private State power;
    private State mode;
    private State intensity;
    private State brightness;
    private State input;
    private State syncStatus;
    private State input1Name;
    private State input1Type;
    private State input1Status;
    private State input1LastMode;
    private State input2Name;
    private State input2Type;
    private State input2Status;
    private State input2LastMode;
    private State input3Name;
    private State input3Type;
    private State input3Status;
    private State input3LastMode;
    private State input4Name;
    private State input4Type;
    private State input4Status;
    private State input4LastMode;
    private State outputName;
    private State outputType;
    private State outputStatus;
    private State outputLastMode;
    private HueSyncStateChangedListener handler;

    public HueSyncState(HueSyncStateChangedListener handler) {
        this.handler = handler;
    }

    public void connectionError(String errorMessage) {
        this.handler.connectionError(errorMessage);
    }

    public State getStateForChannelID(String channelID) {
        switch (channelID) {
            case "general#power": {
                return this.power;
            }
            case "general#mode": {
                return this.mode;
            }
            case "general#intensity": {
                return this.intensity;
            }
            case "general#brightness": {
                return this.brightness;
            }
            case "general#input": {
                return this.input;
            }
            case "general#syncStatus": {
                return this.syncStatus;
            }
            case "input1#name": {
                return this.input1Name;
            }
            case "input1#type": {
                return this.input1Type;
            }
            case "input1#status": {
                return this.input1Status;
            }
            case "input1#lastMode": {
                return this.input1LastMode;
            }
            case "input2#name": {
                return this.input2Name;
            }
            case "input2#type": {
                return this.input2Type;
            }
            case "input2#status": {
                return this.input2Status;
            }
            case "input2#lastMode": {
                return this.input2LastMode;
            }
            case "input3#name": {
                return this.input3Name;
            }
            case "input3#type": {
                return this.input3Type;
            }
            case "input3#status": {
                return this.input3Status;
            }
            case "input3#lastMode": {
                return this.input3LastMode;
            }
            case "input4#name": {
                return this.input4Name;
            }
            case "input4#type": {
                return this.input4Type;
            }
            case "input4#status": {
                return this.input4Status;
            }
            case "input4#lastMode": {
                return this.input4LastMode;
            }
            case "output#name": {
                return this.outputName;
            }
            case "output#type": {
                return this.outputType;
            }
            case "output#status": {
                return this.outputStatus;
            }
            case "output#lastMode": {
                return this.outputLastMode;
            }
        }
        return null;
    }

    public void setPower(boolean power) {
        OnOffType newVal;
        OnOffType onOffType = newVal = power ? OnOffType.ON : OnOffType.OFF;
        if (newVal != this.power) {
            this.power = newVal;
            this.handler.stateChanged("general#power", this.power);
        }
    }

    public void setMode(String mode) {
        StringType newVal = StringType.valueOf((String)mode);
        if (!newVal.equals((Object)this.mode)) {
            this.mode = newVal;
            this.handler.stateChanged("general#mode", this.mode);
        }
    }

    public void setIntensity(String intensity) {
        StringType newVal = StringType.valueOf((String)intensity);
        if (!newVal.equals((Object)this.intensity)) {
            this.intensity = newVal;
            this.handler.stateChanged("general#intensity", this.intensity);
        }
    }

    public void setBrightness(int brightness) {
        PercentType newVal = new PercentType(brightness);
        if (!newVal.equals((Object)this.brightness)) {
            this.brightness = newVal;
            this.handler.stateChanged("general#brightness", this.brightness);
        }
    }

    public void setInput(String input) {
        StringType newVal = StringType.valueOf((String)input);
        if (!newVal.equals((Object)this.input)) {
            this.input = newVal;
            this.handler.stateChanged("general#input", this.input);
        }
    }

    public void setSyncStatus(boolean active) {
        OnOffType newVal;
        OnOffType onOffType = newVal = active ? OnOffType.ON : OnOffType.OFF;
        if (newVal != this.syncStatus) {
            this.syncStatus = newVal;
            this.handler.stateChanged("general#syncStatus", this.syncStatus);
        }
    }

    public void setInput1Name(String name) {
        StringType newVal = StringType.valueOf((String)name);
        if (!newVal.equals((Object)this.input1Name)) {
            this.input1Name = newVal;
            this.handler.stateChanged("input1#name", this.input1Name);
        }
    }

    public void setInput1Type(String type) {
        StringType newVal = StringType.valueOf((String)type);
        if (!newVal.equals((Object)this.input1Type)) {
            this.input1Type = newVal;
            this.handler.stateChanged("input1#type", this.input1Type);
        }
    }

    public void setInput1Status(String status) {
        StringType newVal = StringType.valueOf((String)status);
        if (!newVal.equals((Object)this.input1Status)) {
            this.input1Status = newVal;
            this.handler.stateChanged("input1#status", this.input1Status);
        }
    }

    public void setInput1LastMode(String mode) {
        StringType newVal = StringType.valueOf((String)mode);
        if (!newVal.equals((Object)this.input1LastMode)) {
            this.input1LastMode = newVal;
            this.handler.stateChanged("input1#lastMode", this.input1LastMode);
        }
    }

    public void setInput2Name(String name) {
        StringType newVal = StringType.valueOf((String)name);
        if (!newVal.equals((Object)this.input2Name)) {
            this.input2Name = newVal;
            this.handler.stateChanged("input2#name", this.input2Name);
        }
    }

    public void setInput2Type(String type) {
        StringType newVal = StringType.valueOf((String)type);
        if (!newVal.equals((Object)this.input2Type)) {
            this.input2Type = newVal;
            this.handler.stateChanged("input2#type", this.input2Type);
        }
    }

    public void setInput2Status(String status) {
        StringType newVal = StringType.valueOf((String)status);
        if (!newVal.equals((Object)this.input2Status)) {
            this.input2Status = newVal;
            this.handler.stateChanged("input2#status", this.input2Status);
        }
    }

    public void setInput2LastMode(String mode) {
        StringType newVal = StringType.valueOf((String)mode);
        if (!newVal.equals((Object)this.input2LastMode)) {
            this.input2LastMode = newVal;
            this.handler.stateChanged("input2#lastMode", this.input2LastMode);
        }
    }

    public void setInput3Name(String name) {
        StringType newVal = StringType.valueOf((String)name);
        if (!newVal.equals((Object)this.input3Name)) {
            this.input3Name = newVal;
            this.handler.stateChanged("input3#name", this.input3Name);
        }
    }

    public void setInput3Type(String type) {
        StringType newVal = StringType.valueOf((String)type);
        if (!newVal.equals((Object)this.input3Type)) {
            this.input3Type = newVal;
            this.handler.stateChanged("input3#type", this.input3Type);
        }
    }

    public void setInput3Status(String status) {
        StringType newVal = StringType.valueOf((String)status);
        if (!newVal.equals((Object)this.input3Status)) {
            this.input3Status = newVal;
            this.handler.stateChanged("input3#status", this.input3Status);
        }
    }

    public void setInput3LastMode(String mode) {
        StringType newVal = StringType.valueOf((String)mode);
        if (!newVal.equals((Object)this.input3LastMode)) {
            this.input3LastMode = newVal;
            this.handler.stateChanged("input3#lastMode", this.input3LastMode);
        }
    }

    public void setInput4Name(String name) {
        StringType newVal = StringType.valueOf((String)name);
        if (!newVal.equals((Object)this.input4Name)) {
            this.input4Name = newVal;
            this.handler.stateChanged("input4#name", this.input4Name);
        }
    }

    public void setInput4Type(String type) {
        StringType newVal = StringType.valueOf((String)type);
        if (!newVal.equals((Object)this.input4Type)) {
            this.input4Type = newVal;
            this.handler.stateChanged("input4#type", this.input4Type);
        }
    }

    public void setInput4Status(String status) {
        StringType newVal = StringType.valueOf((String)status);
        if (!newVal.equals((Object)this.input4Status)) {
            this.input4Status = newVal;
            this.handler.stateChanged("input4#status", this.input4Status);
        }
    }

    public void setInput4LastMode(String mode) {
        StringType newVal = StringType.valueOf((String)mode);
        if (!newVal.equals((Object)this.input4LastMode)) {
            this.input4LastMode = newVal;
            this.handler.stateChanged("input4#lastMode", this.input4LastMode);
        }
    }

    public void setOutputName(String name) {
        StringType newVal = StringType.valueOf((String)name);
        if (!newVal.equals((Object)this.outputName)) {
            this.outputName = newVal;
            this.handler.stateChanged("output#name", this.outputName);
        }
    }

    public void setOutputType(String type) {
        StringType newVal = StringType.valueOf((String)type);
        if (!newVal.equals((Object)this.outputType)) {
            this.outputType = newVal;
            this.handler.stateChanged("output#type", this.outputType);
        }
    }

    public void setOutputStatus(String status) {
        StringType newVal = StringType.valueOf((String)status);
        if (!newVal.equals((Object)this.outputStatus)) {
            this.outputStatus = newVal;
            this.handler.stateChanged("output#status", this.outputStatus);
        }
    }

    public void setOutputLastMode(String mode) {
        StringType newVal = StringType.valueOf((String)mode);
        if (!newVal.equals((Object)this.outputLastMode)) {
            this.outputLastMode = newVal;
            this.handler.stateChanged("output#lastMode", this.outputLastMode);
        }
    }
}

