/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.huesync.internal;

import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.openhab.binding.huesync.internal.HueSyncBindingConstants;
import org.openhab.binding.huesync.internal.handler.HueSyncHandler;
import org.openhab.core.io.net.http.HttpClientFactory;
import org.openhab.core.io.net.http.HttpClientInitializationException;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.binding.BaseThingHandlerFactory;
import org.openhab.core.thing.binding.ThingHandler;
import org.openhab.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThingHandlerFactory.class}, configurationPid={"binding.huesync"})
@NonNullByDefault
public class HueSyncHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Collections.singleton(HueSyncBindingConstants.THING_TYPE_SYNCBOX);
    private final HttpClient httpClient = new HttpClient((SslContextFactory)new SslContextFactory.Client(true));

    @Activate
    public HueSyncHandlerFactory(@Reference HttpClientFactory httpClientFactory) {
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            throw new HttpClientInitializationException("Could not start HttpClient", (Throwable)e);
        }
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)HueSyncBindingConstants.THING_TYPE_SYNCBOX)) {
            return new HueSyncHandler(thing, this.httpClient);
        }
        return null;
    }
}

